﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace ZdarzeniaTrasowane
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private int licznik = 0;

        private void button_Click(object sender, RoutedEventArgs e)
        {
            (sender as Button).Background = new SolidColorBrush(Colors.Yellow);
            listBox.Items.Add(String.Format(
                "C: licznik=" + licznik.ToString() +
                ", nadawca: " + (sender as Control).Name +
                ", źródło: " + (e.Source as Control).Name +
                ", oryginalne źródło: " + (e.OriginalSource as Control).Name));
            if (checkBox.IsChecked.Value && licznik == 1)
            {
                e.Handled = true;
                licznik = 0;
                return;
            }
            licznik++;
        }

        private void button_PreviewMouseDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            (sender as Button).Background = new SolidColorBrush(Colors.Orange);
            listBox.Items.Add(String.Format(
                "PMD: licznik=" + licznik.ToString() +
                ", nadawca: " + (sender as Control).Name +
                ", źródło: " + (e.Source as Control).Name +
                ", oryginalne źródło: " + (e.OriginalSource as UIElement).ToString()));
            if (checkBox.IsChecked.Value && licznik == 1)
            {
                e.Handled = true;
                licznik = 0;
                return;
            }
            licznik++;
        }
    }
}
